
/* Copyright (C) 2001-2007 Monotype Imaging Inc. All rights reserved. */

/* Confidential information of Monotype Imaging Inc. */

/* fs_ra_ttf.c */


#include "fs_itype.h"

#ifdef FS_ACT3

/* Find ACT table */
static FS_BYTE* findACTtable( FS_BYTE *sfnt)
{
    sfnt_TableTag tag;
    FS_USHORT numTables;
    FS_SHORT i;
    FS_ULONG fontOff, tableOffset, tabletag;

    /* check for TrueTypeCollection, set flag & #-fonts-in-file if so */
    tag = *((sfnt_TableTag *)((FS_BYTE *)sfnt + TTC_TAG));

    if ( SWAPL(tag) == TAG_ttcf )
        fontOff = SWAPL( GET_ttc_font_offset( sfnt, 0 ) );  /* directory of zero-th font */
    else
        fontOff = 0;
    numTables = SWAPW(GET_sfnt_numOffsets( sfnt + fontOff ));

    for ( i = 0; i < numTables; i++ )
    {
        tabletag = GET_sfnt_table_tag( sfnt + fontOff, i );
        tag = SWAPL(tabletag);
        if (tag == TAG_act3)
        {
            tableOffset = SWAPL(GET_sfnt_table_offset( sfnt + fontOff, i ));
            return &sfnt[tableOffset];
        }
    }
    return NULL;
}
/* The constructor. */


MTX_RA_TT_Decomp *MTX_RA_TT_Create( _DS_ FS_BYTE *compressedData)
{
    MTX_RA_TT_Decomp *t;
    MTX_ROM_BLOCK *rb;
    FS_SHORT numEntries, i;
    FS_BYTE *sfnt, *actTable;
    FS_ULONG version;
    FS_ULONG tag;

    /* If font is a TTC, version follows the "TTC" tag */
    SYS_MEMCPY(&tag, compressedData, sizeof(FS_ULONG));
    tag = SWAPL(tag);
    if (tag == TAG_ttcf)
    {
        SYS_MEMCPY(&version, compressedData + 4, sizeof(FS_ULONG));
        version = SWAPL(version);
    }
    else
        version = tag;
    if (version != 0x00010000 && version != 0x00020000 && version != 0x74727565 && version != 0x4F54544F)    /* allow 'true' as version number -- mrr */
    {
        STATE.error = ERR_NOT_A_TTF;
        return NULL;
    }

#ifdef FS_MEM_DBG
    STATE.memdbgid = "MTX_RA_TT_Decomp";
#endif
    t = (MTX_RA_TT_Decomp *)FSS_calloc(_PS_ sizeof( MTX_RA_TT_Decomp ) );
    if (t == 0)
        return NULL;

    sfnt = compressedData;

    t->tc = MTX_TABLE_COMPRESS_Create( _PS0_);

    if (t->tc == 0)
    {
        FSS_free(_PS_ t);
        return NULL;
    }

    actTable = findACTtable( (FS_BYTE *)compressedData);
    if (actTable == 0)
    {
        FSS_free(_PS_ t->tc);
        FSS_free(_PS_ t);
        return NULL;
    }

    if ( MTX_RA_TT_ReadRom(_PS_ t, actTable) == 0)
    {
        FSS_free(_PS_ t->tc->rb);
        FSS_free(_PS_ t->tc);
        FSS_free(_PS_ t);
        return NULL;
    }

    rb = t->tc->rb;
    numEntries = t->tc->numEntries;
    t->cmpStart = sfnt;
    t->cmpEnd   = sfnt + t->cmpSize;
    for (i = 0; i < numEntries; i++)
    {
        if (rb[i].isCompressed)
        {
            rb[i].decomp = MTX_RA_DECOMP_Create( _PS_ sfnt + rb[i].cmpStart);
            if (rb[i].decomp == 0)
            {
                while (i >= 0)
                {
                    if (rb[i].isCompressed)
                        MTX_RA_DECOMP_Destroy(_PS_ rb[i].decomp);
                    i--;
                }
                FSS_free(_PS_ t->tc->rb);
                FSS_free(_PS_ t->tc);
                FSS_free(_PS_ t);
                return NULL;
            }
        }
    }
    /*MTX_TTC_InitCoordEncoding(); */

    return t;
}

/*lint -e838 Warning -- Previously assigned value to variable has not been used     */

FS_ULONG MTX_RA_TT_getUncompressedFileSize(FS_VOID * sfnt)
{
    FS_BYTE *actTable;
    FS_ULONG uncmpSize;
    actTable = findACTtable(sfnt);
    if (!actTable)
        return 0;
    uncmpSize = READWORD_INC(&actTable); /* headerLength */
    uncmpSize = READLONG_INC(&actTable); /* cmpSize      */
    uncmpSize = READLONG_INC(&actTable);
    return uncmpSize;
}
/*lint +e838 Warning -- Previously assigned value to variable has not been used     */

/*
 * Returns a pointer to the requested data in the ctf data.
 * The caller sets *length to the requested length, and if we return more
 * then we reset *length to the actual length.
 * For reads within the glyph table the function assumes that the client
 * only request entire glyphs. No multi-glyph or partial glyph reads are allowed.
 * CTF data is translated to TTF format on the fly.
 */
FS_BYTE *MTX_RA_Get_TTF_FragmentPtr( _DS_ MTX_RA_TT_Decomp *t, FS_ULONG position, FS_ULONG *byteCountPtr )
{
    MTX_ROM_BLOCK *rb;
    int  i;    /* yes, I really do mean unqualified lowercase 'int' */
    FS_BYTE *data;

    if ( *byteCountPtr == 0 )
        return NULL;

    rb = (MTX_ROM_BLOCK *)(t->tc->rb);
    for (i = t->tc->numEntries - 1; i >= 0; i--)   /* start at end */
    {
        if (position >= rb[i].start)
            break;
    }
#ifdef BYTE_CACHE_INTERVAL /* VL - 4/09/03 */
    if (rb[i].isCompressed)
        data = MTX_RA_GetFragmentPtr( _PS_ rb[i].decomp, position - rb[i].start, byteCountPtr );
    else
        data = t->cmpStart + rb[i].cmpStart + position - rb[i].start;
#else
    if (rb[i].isCompressed)
    {
        if (rb[i].isCompressed == 1)
            /* VL - we need to assure backward compatibility for old .ac3 files with fixed 128 byte interval */
            data = MTX_RA_GetFragmentPtr( _PS_ rb[i].decomp, position - rb[i].start, byteCountPtr, 128 );
        else
            /* VL - the byte cache interval is variable and encoded in "isCompressed" field */
            data = MTX_RA_GetFragmentPtr( _PS_ rb[i].decomp, position - rb[i].start, byteCountPtr, rb[i].isCompressed );
    }
    else
        data = t->cmpStart + rb[i].cmpStart + position - rb[i].start;
#endif /* BYTE_CACHE_INTERVAL */

    if (!data)
        return NULL;

    /* if a glyph read then expand the ctf spline data to ttf spline data */
    if ( position >= t->glyf_OffsetStart && position < t->glyf_OffsetEnd )
    {
        /* CCC fonts aren't in CTF form ... don't translate */
        if (!(STATE.cur_lfnt->fontflags & (FONTFLAG_CCC | FONTFLAG_DDD)))
        {

            FS_BYTE *ttf_data;

            ttf_data = MTX_TTC_GetTTFGlyphMemory( _PS_ data, *byteCountPtr, byteCountPtr);
            if (STATE.error)
            {
                MTX_RA_ReleaseTTF_Fragment(_PS_ t, data );
                data = 0;
                return data;
            }

            MTX_RA_ReleaseTTF_Fragment(_PS_ t, data );
            data = ttf_data;
        }
    }

    return data;
}

/*
 * Releases the memory previously allocated by MTX_RA_Get_TTF_FragmentPtr,
 */
FS_VOID MTX_RA_ReleaseTTF_Fragment( _DS_ MTX_RA_TT_Decomp *t, FS_VOID * data )
{
    /* Only free ptrs outside of the compressed font. Pointers inside are "ROM pointers" */
    if ((FS_BYTE*)data < t->cmpStart || t->cmpEnd < (FS_BYTE*)data)
        FSS_free(_PS_ data);
}


/* The destructor. */
FS_VOID MTX_RA_TT_Destroy(_DS_ MTX_RA_TT_Decomp *t )
{
    MTX_ROM_BLOCK *rb;
    FS_SHORT numEntries, i;

    rb = t->tc->rb;
    numEntries = t->tc->numEntries;
    for (i = 0; i < numEntries; i++)
        if (rb[i].isCompressed)
            MTX_RA_DECOMP_Destroy(_PS_ rb[i].decomp);
    MTX_TABLE_COMPRESS_Destroy(_PS_ t->tc);
    FSS_free(_PS_ t);
}

#endif /* FS_ACT3 */
